<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
	<chart average_selection="yes" rendering_type="line" series_composition="overlay" title="Frame Rate">
		<series color="19,148,180" description="The context frame rate" display="AVERAGE" match_with="$FrameRateEGLContext*" name="Frame rate GLES ${*}" units="FPS"/>
		<series color="19,148,180" description="The device frame rate" display="AVERAGE" match_with="$FrameRateVkDevice*" name="Frame rate Vk ${*}" units="FPS"/>
	</chart>
	<chart average_selection="yes" rendering_type="bar" series_composition="stacked" title="Device Thermal State">
		<series color="41,189,111" description="Device is not being throttled" display="AVERAGE" expression="$AndroidThermalThrottlingNone * 100" name="No throttle" units="%"/>
		<series color="230,230,100" description="Device is being lightly throttled" display="AVERAGE" expression="$AndroidThermalThrottlingLight * 100" name="Light throttle" units="%"/>
		<series color="246,138,51" description="Device is being moderately throttled" display="AVERAGE" expression="$AndroidThermalThrottlingModerate * 100" name="Moderate throttle" units="%"/>
		<series color="227,80,45" description="Device is being severely throttled" display="AVERAGE" expression="$AndroidThermalThrottlingSevere * 100" name="Severe throttle" units="%"/>
		<series color="177,35,65" description="Device is in a critical, or more severe, thermal state" display="AVERAGE" expression="($AndroidThermalThrottlingCritical + $AndroidThermalThrottlingEmergency + $AndroidThermalThrottlingShutdown) * 100" name="Critical+ throttle" units="%"/>
	</chart>
	<chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
		<series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
		<series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
	</chart>
	<chart average_cores="yes" average_selection="yes" height="61" rendering_type="line" series_composition="overlay" title="CPU Cycles">
		<series color="66,188,72" description="The number of core clock cycles" display="ACCUMULATE" expression="$CyclesCPUCycles" name="Cycles" units="cycles"/>
	</chart>
	<chart average_selection="yes" rendering_type="line" series_composition="overlay" title="Workloads / Frame">
		<series colorList="(19,148,180),(119,218,241),(11,90,109)" description="The number of context render passes per frame" display="AVERAGE" match_with="$RenderPassesFrameEGLContext*" name="Render passes GLES ${*}" units="passes"/>
		<series colorList="(119,218,241),(11,90,109),(19,148,180)" description="The number of device render passes per frame" display="AVERAGE" match_with="$RenderPassesFrameVkDevice*" name="Render passes Vk ${*}" units="passes"/>
		<series colorList="(41,203,118),(167,237,200),(24,116,68)" description="The number of context compute dispatches per frame" display="AVERAGE" match_with="$ComputeDispatchesFrameEGLContext*" name="Compute dispatches GLES ${*}" units="dispatches"/>
		<series colorList="(167,237,200),(24,116,68),(41,203,118)" description="The number of device compute dispatches per frame" display="AVERAGE" match_with="$ComputeDispatchesFrameVkDevice*" name="Compute dispatches Vk ${*}" units="dispatches"/>
		<series colorList="(246,138,51),(251,195,149),(182,87,8)" description="The number of device trace rays calls per frame" display="AVERAGE" match_with="$TraceRaysFrameVkDevice*" name="Trace rays Vk ${*}" units="calls"/>
	</chart>
	<chart average_selection="yes" rendering_type="line" series_composition="overlay" title="Draw Calls / Frame">
		<series color="164,71,164" description="The number of context draw calls per frame" display="AVERAGE" match_with="$DrawCallsFrameEGLContext*" name="Draw calls GLES ${*}" units="draws"/>
		<series color="164,71,164" description="The number of device draw calls per frame" display="AVERAGE" match_with="$DrawCallsFrameVkDevice*" name="Draw calls Vk ${*}" units="draws"/>
	</chart>
	<chart average_selection="yes" height="55" percentage="yes" rendering_type="bar" series_composition="stacked" title="Mali GPU Non-fragment Activity">
		<series color="246,138,51" description="GPU non-fragment slot activity" display="AVERAGE" expression="$GPUVertexTilingComputeActivity" name="Non-fragment"/>
	</chart>
	<chart average_selection="yes" height="55" percentage="yes" rendering_type="bar" series_composition="stacked" title="Mali GPU Fragment Activity">
		<series color="19,148,180" description="GPU fragment slot activity" display="AVERAGE" expression="$GPUFragmentActivity" name="Fragment"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali GPU Usage">
		<series color="164,71,164" description="The number of cycles when the GPU has a workload of any type queued for processing" expression="$MaliGPUCyclesGPUActive" name="GPU active" units="cycles"/>
		<series color="246,138,51" description="The number of cycles when work is queued in the GPU non-fragment queue" expression="$MaliGPUCyclesNonFragmentQueueActive" name="Non-fragment queue active" units="cycles"/>
		<series color="19,148,180" description="The number of cycles when work is queued for processing in the GPU fragment queue" expression="$MaliGPUCyclesFragmentQueueActive" name="Fragment queue active" units="cycles"/>
		<series color="251,195,149" description="The number of cycles when the tiler has a workload queued for processing" expression="$MaliGPUCyclesTilerActive" name="Tiler active" units="cycles"/>
		<series color="217,21,74" description="The number of cycles when the GPU has a pending interrupt" expression="$MaliGPUCyclesGPUInterruptActive" name="GPU interrupt active" units="cycles"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali GPU Utilization">
		<series color="246,138,51" description="The non-fragment queue utilization compared against the GPU active cycles" expression="max(min(($MaliGPUCyclesNonFragmentQueueActive / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Non-fragment queue utilization" units="%"/>
		<series color="19,148,180" description="The fragment queue utilization compared against the GPU active cycles" expression="max(min(($MaliGPUCyclesFragmentQueueActive / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Fragment queue utilization" units="%"/>
		<series color="251,195,149" description="The percentage of GPU active cycles where the tiler has a workload queued for processing" expression="max(min(($MaliGPUCyclesTilerActive / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Tiler utilization" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Memory Bandwidth Usage">
		<series color="41,203,118" description="The total output read bandwidth for the GPU" expression="$MaliExternalBusBeatsReadBeats * ($MaliConstantsBusWidthBits / 8)" name="Read bytes" units="bytes"/>
		<series color="217,21,74" description="The total output write bandwidth for the GPU" expression="$MaliExternalBusBeatsWriteBeats * ($MaliConstantsBusWidthBits / 8)" name="Write bytes" units="bytes"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Memory Stall Rate">
		<series color="41,203,118" description="The percentage of cycles with an external read transaction stalled" expression="max(min(($MaliExternalBusStallCyclesReadStall / $MaliConstantsL2SliceCount / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Read stall rate" units="%"/>
		<series color="217,21,74" description="The percentage of cycles with an external write transaction stalled" expression="max(min(($MaliExternalBusStallCyclesWriteStall / $MaliConstantsL2SliceCount / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Write stall rate" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Geometry Usage">
		<series color="41,189,111" description="The number of primitives that are visible after culling" expression="$MaliPrimitiveCullingVisiblePrimitives" name="Visible primitives" units="primitives"/>
		<series color="227,80,45" description="The number of primitives that were culled during the rendering process" expression="$MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives + $MaliPrimitiveCullingZPlaneTestCulledPrimitives" name="Culled primitives" units="primitives"/>
		<series color="246,138,51" description="The total number of input primitives to the rendering process" expression="$MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives + $MaliPrimitiveCullingZPlaneTestCulledPrimitives + $MaliPrimitiveCullingVisiblePrimitives" name="Input primitives" units="primitives"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Geometry Culling Rate">
		<series color="41,189,111" description="The percentage of primitives that are visible after culling" expression="max(min(($MaliPrimitiveCullingVisiblePrimitives / ($MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives + $MaliPrimitiveCullingZPlaneTestCulledPrimitives + $MaliPrimitiveCullingVisiblePrimitives)) * 100, 100), 0)" name="Visible primitive rate" units="%"/>
		<series color="246,138,51" description="The percentage of primitives culled by the facing or frustum XY plane tests" expression="max(min(($MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives / ($MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives + $MaliPrimitiveCullingZPlaneTestCulledPrimitives + $MaliPrimitiveCullingVisiblePrimitives)) * 100, 100), 0)" name="Facing or XY plane culled primitive rate" units="%"/>
		<series color="227,80,45" description="The percentage of primitives culled by the frustum Z plane test" expression="max(min(($MaliPrimitiveCullingZPlaneTestCulledPrimitives / (($MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives + $MaliPrimitiveCullingZPlaneTestCulledPrimitives + $MaliPrimitiveCullingVisiblePrimitives) - $MaliPrimitiveCullingFacingOrXYPlaneTestCulledPrimitives)) * 100, 100), 0)" name="Z plane culled primitive rate" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="stacked" title="Mali Pixels">
		<series color="19,148,180" description="The total number of pixels that are shaded" expression="$MaliGPUTasksFragmentTasks * 256" name="Pixels" units="pixels"/>
	</chart>
	<chart rendering_type="line" series_composition="stacked" title="Mali Overdraw">
		<series color="19,148,180" description="The number of fragments shaded per output pixel" expression="$MaliShaderThreadsFragmentThreads / ($MaliGPUTasksFragmentTasks * 256)" name="Fragments/pixel" units="threads"/>
	</chart>
	<chart rendering_type="line" series_composition="stacked" title="Mali Pixel Throughput">
		<series color="19,148,180" description="The average number of GPU cycles spent per pixel rendered" expression="$MaliGPUCyclesGPUActive / ($MaliGPUTasksFragmentTasks * 256)" name="Average GPU cycles/pixel" units="cycles"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Early ZS Rate">
		<series color="41,189,111" description="The percentage of rasterized quads that were subjected to early depth and stencil testing" expression="max(min(($MaliFragmentZSQuadsEarlyZSTestedQuads / $MaliFragmentQuadsRasterizedFineQuads) * 100, 100), 0)" name="Early ZS test rate" units="%"/>
		<series color="246,138,51" description="The percentage of rasterized quads that are killed by early depth and stencil testing" expression="max(min(($MaliFragmentZSQuadsEarlyZSKilledQuads / $MaliFragmentQuadsRasterizedFineQuads) * 100, 100), 0)" name="Early ZS kill rate" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Late ZS Rate">
		<series color="177,35,65" description="The percentage of rasterized threads that are tested by late depth and stencil testing" expression="max(min(($MaliShaderThreadsLateZSTestedThreads / ($MaliFragmentQuadsRasterizedFineQuads * 4)) * 100, 100), 0)" name="Late ZS test rate" units="%"/>
		<series color="117,43,84" description="The percentage of rasterized threads that are killed by late depth and stencil testing" expression="max(min(($MaliShaderThreadsLateZSKilledThreads / ($MaliFragmentQuadsRasterizedFineQuads * 4)) * 100, 100), 0)" name="Late ZS kill rate" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Core Threads">
		<series color="246,138,51" description="The number of non-fragment threads started" expression="$MaliShaderThreadsNonFragmentThreads" name="Non-fragment threads" units="threads"/>
		<series color="19,148,180" description="The number of fragment threads started" expression="$MaliShaderThreadsFragmentThreads" name="Fragment threads" units="threads"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Core Throughput">
		<series color="246,138,51" description="The average number of shader core cycles per non-fragment thread" expression="$MaliShaderCoreCyclesNonFragmentActive / $MaliShaderThreadsNonFragmentThreads" name="Cycles/non-fragment thread" units="cycles"/>
		<series color="19,148,180" description="The average number of shader core cycles per fragment thread" expression="$MaliShaderCoreCyclesFragmentActive / $MaliShaderThreadsFragmentThreads" name="Cycles/fragment thread" units="cycles"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Core Utilization">
		<series color="246,138,51" description="The utilization of the shader core non-fragment path" expression="max(min(($MaliShaderCoreCyclesNonFragmentActive / $MaliConstantsShaderCoreCount / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Non-fragment utilization" units="%"/>
		<series color="19,148,180" description="The utilization of the shader core fragment path" expression="max(min(($MaliShaderCoreCyclesFragmentActive / $MaliConstantsShaderCoreCount / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Fragment utilization" units="%"/>
		<series color="119,218,241" description="The percentage of cycles where at least one quad is buffered for fragment shading" expression="max(min(($MaliShaderCoreCyclesFragmentFPKBufferActive / $MaliShaderCoreCyclesFragmentActive) * 100, 100), 0)" name="Fragment FPK buffer utilization" units="%"/>
		<series color="217,21,74" description="The utilization of the programmable shader core" expression="max(min(($MaliShaderCoreCyclesExecutionCoreActive / $MaliConstantsShaderCoreCount / $MaliGPUCyclesGPUActive) * 100, 100), 0)" name="Execution core utilization" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Core Unit Utilization">
		<series color="164,71,164" description="The percentage utilization of the arithmetic unit" expression="max(min(($MaliALUInstructionsExecutedInstructions / $MaliShaderCoreCyclesExecutionCoreActive) * 100, 100), 0)" name="Arithmetic unit utilization" units="%"/>
		<series color="19,148,180" description="The percentage utilization of the texturing unit" expression="max(min(($MaliTextureUnitCyclesFilteringActive / $MaliShaderCoreCyclesExecutionCoreActive) * 100, 100), 0)" name="Texture unit utilization" units="%"/>
		<series color="246,138,51" description="The percentage utilization of the load/store unit" expression="max(min(($MaliLoadStoreUnitCyclesLoadStoreUnitIssue / $MaliShaderCoreCyclesExecutionCoreActive) * 100, 100), 0)" name="Load/store unit utilization" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Core Workload Property Rate">
		<series color="41,203,118" description="The percentage of fragment threads that are helper threads" expression="max(min(($MaliShaderThreadsFragmentThreads / $MaliShaderThreadsFragmentHelperThreads) * 100, 100), 0)" name="Helper thread rate" units="%"/>
		<series color="164,71,164" description="The percentage of tiles that are killed by transaction elimination" expression="max(min(($MaliShaderCoreTilesKilledUnchangedTiles / $MaliShaderCoreTilesTiles) * 100, 100), 0)" name="Unchanged tile kill rate" units="%"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Texture Usage">
		<series color="19,148,180" description="The number of texture filtering issue cycles" expression="$MaliTextureUnitCyclesFilteringActive" name="Filtering active" units="cycles"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Texture CPI">
		<series color="19,148,180" description="The average number of texture filtering cycles per instruction" expression="$MaliTextureUnitCyclesFilteringActive / $MaliTextureUnitRequestsTextureRequests" name="Texture CPI" units="cycles"/>
	</chart>
	<chart rendering_type="line" series_composition="overlay" title="Mali Load/Store Usage">
		<series color="164,71,164" description="The total number of load/store issue cycles" expression="$MaliLoadStoreUnitCyclesLoadStoreUnitIssue" name="Load/store unit issue" units="cycles"/>
		<series color="41,203,118" description="The total number of load/store read cycles" expression="$MaliLoadStoreUnitCyclesRead" name="Read" units="cycles"/>
		<series color="217,21,74" description="The total number of load/store write cycles" expression="$MaliLoadStoreUnitCyclesWrite" name="Write" units="cycles"/>
		<series color="246,138,51" description="The number of load/store atomic accesses" expression="$MaliLoadStoreUnitCyclesAtomicAccess" name="Atomic access" units="cycles"/>
	</chart>
</template>
